package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Filter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.material.EqualizerView;
import androidx.nemosofts.material.ImageHelperView;
import androidx.nemosofts.theme.ColorUtils;
import androidx.nemosofts.utils.FormatUtils;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.RecyclerView;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.like.LikeButton;
import com.like.OnLikeListener;
import com.squareup.picasso.Picasso;
import com.startapp.sdk.ads.nativead.NativeAdDetails;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.executor.LoadStatus;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;


public class AdapterRadioList extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final Context context;
    private List<ItemRadio> arrayList;
    private final List<ItemRadio> filteredArrayList;
    private final RecyclerItemClickListener listener;
    private NameFilter filter;
    private final Helper helper;
    private final SPHelper spHelper;
    private static final int VIEW_PROG = -1;
    Boolean isNumber;
    Boolean isAdLoaded = false;
    List<NativeAd> mNativeAdsAdmob = new ArrayList<>();
    List<NativeAdDetails> nativeAdsStartApp = new ArrayList<>();

    public AdapterRadioList(Context context, boolean isNumber, List<ItemRadio> arrayList, RecyclerItemClickListener clickListener) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.listener = clickListener;
        this.isNumber = isNumber;
        helper = new Helper(context);
        spHelper = new SPHelper(context);
    }

    public static class MyViewHolder extends RecyclerView.ViewHolder {

        private final RelativeLayout relativeLayout;
        private final ImageHelperView poster;
        private final EqualizerView equalizer;
        private final TextView radioTitle;
        private final TextView catName;
        private final TextView avgRate;
        private final TextView viewsRadio;
        private final TextView number;
        private final TextView premium;
        private final RatingBar ratingBar;
        private final ImageView option;
        private final LikeButton likeButton;
        private final RelativeLayout nativeAd;

        MyViewHolder(View view) {
            super(view);
            relativeLayout = view.findViewById(R.id.rl_radio_list);
            poster = view.findViewById(R.id.iv_radio_list);
            equalizer = view.findViewById(R.id.equalizer_radio_list);
            radioTitle = view.findViewById(R.id.tv_radio_list_name);
            catName = view.findViewById(R.id.tv_radio_list_cat);
            ratingBar = view.findViewById(R.id.rb_radio_list);
            avgRate = view.findViewById(R.id.tv_radio_list_avg_rate);
            viewsRadio = view.findViewById(R.id.tv_radio_list_views);
            likeButton = itemView.findViewById(R.id.iv_radio_fav_list);
            option = view.findViewById(R.id.iv_list_option);
            premium = view.findViewById(R.id.tv_radio_list_premium);
            number = view.findViewById(R.id.tv_number);
            nativeAd = view.findViewById(R.id.rl_native_ad);
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        private ProgressViewHolder(View v) {
            super(v);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_PROG) {
            View v = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        } else {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.item_row_radio_vertical, parent, false);
            return new MyViewHolder(itemView);
        }
    }

    @SuppressLint("SetTextI18n")
    @OptIn(markerClass = UnstableApi.class)
    @Override
    public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof MyViewHolder myViewHolder) {

            myViewHolder.radioTitle.setText(arrayList.get(position).getRadioTitle());
            myViewHolder.catName.setText(arrayList.get(position).getCategoryName());
            myViewHolder.likeButton.setLiked(arrayList.get(position).getIsFav());
            myViewHolder.viewsRadio.setText(FormatUtils.format(Integer.valueOf(arrayList.get(position).getTotalViews())));
            myViewHolder.premium.setVisibility(Boolean.TRUE.equals(arrayList.get(position).getIsPremium()) ? View.VISIBLE : View.GONE);

            if (Boolean.TRUE.equals(isNumber)){
                myViewHolder.number.setVisibility(View.VISIBLE);
                if (position == 0){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 1){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 2){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 3){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 4){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 5){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 6){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 7){
                    myViewHolder.number.setText("0" + (position + 1));
                } else if (position == 8){
                    myViewHolder.number.setText("0" + (position + 1));
                } else {
                    myViewHolder.number.setText(String.valueOf(position + 1));
                }
            } else {
                myViewHolder.number.setVisibility(View.GONE);
            }

            Picasso.get()
                    .load(arrayList.get(position).getImage())
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .error(R.drawable.material_design_default)
                    .into(myViewHolder.poster);

            myViewHolder.avgRate.setTypeface(myViewHolder.avgRate.getTypeface(), Typeface.BOLD);
            myViewHolder.avgRate.setText(arrayList.get(position).getAverageRating());
            myViewHolder.ratingBar.setRating(Float.parseFloat(arrayList.get(position).getAverageRating()));

            if (PlayerService.getIsPlaying() && Callback.getPlayPos() <= holder.getAbsoluteAdapterPosition()
                    && Callback.getArrayListPlay().get(Callback.getPlayPos()).getId().equals(arrayList.get(position).getId())
                    && Boolean.TRUE.equals(Callback.getIsRadio())) {
                myViewHolder.equalizer.setVisibility(View.VISIBLE);
                myViewHolder.equalizer.animateBars();

                myViewHolder.relativeLayout.setBackgroundColor(ColorUtils.colorPrimarySub(context));
                myViewHolder.radioTitle.setTextColor(ColorUtils.colorPrimary(context));

            } else {
                myViewHolder.equalizer.setVisibility(View.GONE);
                myViewHolder.equalizer.stopBars();

                myViewHolder.relativeLayout.setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
                myViewHolder.radioTitle.setTextColor(ColorUtils.colorTitle(context));
            }

            myViewHolder.relativeLayout.setOnClickListener(view -> {
                if (Boolean.TRUE.equals(spHelper.getIsSubscribed())){
                    listener.onClick(getPosition(arrayList.get(holder.getAbsoluteAdapterPosition()).getId()));
                } else {
                    if (Boolean.TRUE.equals(arrayList.get(position).getIsPremium()) && Boolean.TRUE.equals(!spHelper.getIsSubscribed())){
                        listener.onRewardAds(position);
                    } else {
                        listener.onClick(getPosition(arrayList.get(holder.getAbsoluteAdapterPosition()).getId()));
                    }
                }
            });

            myViewHolder.option.setOnClickListener(view -> openBottomSheet(holder.getAbsoluteAdapterPosition()));

            if(spHelper.isLogged()) {
                myViewHolder.likeButton.setOnLikeListener(new OnLikeListener() {
                    @Override
                    public void liked(LikeButton likeButton) {
                        loadFav(holder.getAbsoluteAdapterPosition());
                    }

                    @Override
                    public void unLiked(LikeButton likeButton) {
                        loadFav(holder.getAbsoluteAdapterPosition());
                    }
                });
            } else {
                myViewHolder.likeButton.setOnClickListener(view -> {
                    if(!spHelper.isLogged()) {
                        helper.clickLogin();
                    }
                });
            }

            if (Callback.getIsAdsStatus() && isAdLoaded
                    && (holder.getAbsoluteAdapterPosition() != arrayList.size() - 1)
                    && (holder.getAbsoluteAdapterPosition() + 1) % Callback.getNativeAdShow() == 0) {
                try {
                    if (myViewHolder.nativeAd.getChildCount() == 0) {
                        switch (Callback.getAdNetwork()) {
                            case Callback.AD_TYPE_ADMOB, Callback.AD_TYPE_META -> {
                                if (!mNativeAdsAdmob.isEmpty()) {

                                    int i = ApplicationUtil.getRandomValue(mNativeAdsAdmob.size() - 1);

                                    @SuppressLint("InflateParams") NativeAdView adView = (NativeAdView) ((Activity) context)
                                            .getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                    populateUnifiedNativeAdView(mNativeAdsAdmob.get(i), adView);
                                    myViewHolder.nativeAd.removeAllViews();
                                    myViewHolder.nativeAd.addView(adView);

                                    myViewHolder.nativeAd.setVisibility(View.VISIBLE);
                                }
                            }
                            case Callback.AD_TYPE_STARTAPP -> {
                                int i = ApplicationUtil.getRandomValue(nativeAdsStartApp.size() - 1);
                                @SuppressLint("InflateParams") RelativeLayout nativeAdView = (RelativeLayout) ((Activity) context)
                                        .getLayoutInflater().inflate(R.layout.layout_native_ad_startapp, null);
                                populateStartAppNativeAdView(nativeAdsStartApp.get(i), nativeAdView);
                                myViewHolder.nativeAd.removeAllViews();
                                myViewHolder.nativeAd.addView(nativeAdView);
                                myViewHolder.nativeAd.setVisibility(View.VISIBLE);
                            }
                            case Callback.AD_TYPE_APPLOVIN -> {
                                MaxNativeAdLoader nativeAdLoader = getMaxNativeAdLoader(myViewHolder);
                                nativeAdLoader.loadAd();
                            }
                            default ->
                                myViewHolder.nativeAd.setVisibility(View.GONE);
                        }
                    }
                } catch (Exception e) {
                    Log.e("AdapterRadioList","Error onBindViewHolder" ,e);
                }
            }
        }
    }

    @NonNull
    private MaxNativeAdLoader getMaxNativeAdLoader(MyViewHolder holder) {
        MaxNativeAdLoader nativeAdLoader = new MaxNativeAdLoader(Callback.getApplovinNativeAdID(), context);
        nativeAdLoader.setNativeAdListener(new MaxNativeAdListener() {
            @Override
            public void onNativeAdLoaded(final MaxNativeAdView nativeAdView, @NonNull final MaxAd ad) {
                holder.nativeAd.removeAllViews();
                holder.nativeAd.addView(nativeAdView);
                holder.nativeAd.setVisibility(View.VISIBLE);
            }
        });
        return nativeAdLoader;
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (arrayList.get(position) != null) {
            return position;
        } else {
            return VIEW_PROG;
        }
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (!constraint.toString().isEmpty()) {
                ArrayList<ItemRadio> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getRadioTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressLint("NotifyDataSetChanged")
        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            arrayList = (ArrayList<ItemRadio>) results.values;
            notifyDataSetChanged();
        }
    }

    private void loadFav( int adapterPosition) {
        if(spHelper.isLogged()) {
            if (NetworkUtils.isConnected(context)) {
                LoadStatus loadFav = new LoadStatus(new SuccessListener() {
                    @Override
                    public void onStart() {
                        // this method is empty
                    }

                    @Override
                    public void onEnd(String success, String favSuccess, String message) {
                        if (success.equals("1")) {
                            arrayList.get(adapterPosition).setIsFav(message.equals("Added to Favourite"));
                            notifyItemChanged(adapterPosition);
                            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    }
                }, helper.getAPIRequest(Method.METHOD_DO_FAV, 0, arrayList.get(adapterPosition).getId(),
                        "", "", "", spHelper.getUserId(), "", "",
                        "", "", "", "", "radio", null));
                loadFav.execute();
            } else {
                Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            if(!spHelper.isLogged()) {
                helper.clickLogin();
            }
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    private void openBottomSheet(int adapterPosition) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams") View view = inflater.inflate(R.layout.bottom_sheet_radio, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);

        dialog.setOnShowListener(dialogInterface -> {
            FrameLayout bottomSheet = dialog.findViewById(com.google.android.material.R.id.design_bottom_sheet);
            if (bottomSheet != null) {
                // Convert 20dp to pixels
                int marginPx = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 15, context.getResources().getDisplayMetrics());

                // Apply margins to the BottomSheet
                CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams) bottomSheet.getLayoutParams();
                params.setMargins(marginPx, marginPx, marginPx, marginPx);
                bottomSheet.setLayoutParams(params);
            }
        });

        TextView title = dialog.findViewById(R.id.tv_sheet_text);
        TextView catName = dialog.findViewById(R.id.tv_sheet_list_cat);
        ImageHelperView poster = dialog.findViewById(R.id.iv_sheet_post);

        LinearLayout report = dialog.findViewById(R.id.ll_sheet_report);
        LinearLayout share = dialog.findViewById(R.id.ll_sheet_share);
        LinearLayout fav = dialog.findViewById(R.id.ll_sheet_fav);
        LinearLayout rating = dialog.findViewById(R.id.ll_sheet_rating);
        LinearLayout youtube = dialog.findViewById(R.id.ll_sheet_youtube);

        ImageView turned = dialog.findViewById(R.id.iv_turned);
        TextView turnedTitle = dialog.findViewById(R.id.tv_turned);
        if (turned != null && turnedTitle != null){
            if (Boolean.TRUE.equals(arrayList.get(adapterPosition).getIsFav())) {
                turnedTitle.setText(context.getResources().getString(R.string.un_favourite));
                turned.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_heart_fill));
            } else {
                turnedTitle.setText(context.getResources().getString(R.string.add_favourite));
                turned.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_heart_line));
            }
        }

        if (poster != null){
            Picasso.get()
                    .load(arrayList.get(adapterPosition).getImage())
                    .centerCrop()
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .error(R.drawable.material_design_default)
                    .into(poster);
        }

        Objects.requireNonNull(catName).setText(arrayList.get(adapterPosition).getCategoryName());
        Objects.requireNonNull(title).setText(arrayList.get(adapterPosition).getRadioTitle());
        Objects.requireNonNull(report).setOnClickListener(view2 -> {
            new FeedBackDialog((Activity) context).showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getRadioTitle());
            dialog.dismiss();
        });
        Objects.requireNonNull(share).setOnClickListener(view3 -> {
            Intent sharingIntent = new Intent(Intent.ACTION_SEND);
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra(Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.share_radio));
            sharingIntent.putExtra(Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - "
                    + arrayList.get(adapterPosition).getRadioTitle() + "\n\nvia "
                    + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
            context.startActivity(Intent.createChooser(sharingIntent, context.getResources().getString(R.string.share_radio)));
        });
        Objects.requireNonNull(fav).setOnClickListener(view4 -> {
            loadFav(adapterPosition);
            dialog.dismiss();
        });
        Objects.requireNonNull(rating).setOnClickListener(view5 -> {
            ReviewDialog reviewDialog = new ReviewDialog((Activity) context, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {
                    // this method is empty
                }

                @Override
                public void onGetRating(String rating, String message) {
                    arrayList.get(adapterPosition).setUserRating(String.valueOf(rating));
                    arrayList.get(adapterPosition).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating,
                                      String userRating, String userMessage) {
                    if (success.equals("1")) {
                        reviewOnDismiss(rateSuccess, message, rating, userRating, userMessage, adapterPosition);
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }
            });
            reviewDialog.showDialog(arrayList.get(adapterPosition).getId(),
                    arrayList.get(adapterPosition).getUserRating(), arrayList.get(adapterPosition).getUserMessage()
            );
            dialog.dismiss();
        });
        Objects.requireNonNull(youtube).setOnClickListener(view6 -> {
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(adapterPosition).getRadioTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            dialog.dismiss();
        });
        dialog.show();
    }

    private void reviewOnDismiss(String rateSuccess, String message, int rating,
                                 String userRating, String userMessage, int adapterPosition) {
        if (rateSuccess.equals("1")) {
            try {
                arrayList.get(adapterPosition).setAverageRating(String.valueOf(rating));
                arrayList.get(adapterPosition).setTotalRate(String.valueOf(Integer.parseInt(
                        arrayList.get(adapterPosition).getTotalRate() + 1)));
                arrayList.get(adapterPosition).setUserRating(String.valueOf(userRating));
                arrayList.get(adapterPosition).setUserMessage(String.valueOf(userMessage));
                notifyItemChanged(adapterPosition);
            } catch (Exception e) {
                Log.e("AdapterRadioList","Error openBottomSheet" ,e);
            }
        }
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }

    public void addAds(NativeAd unifiedNativeAd) {
        mNativeAdsAdmob.add(unifiedNativeAd);
        isAdLoaded = true;
    }

    public void addNativeAds(List<NativeAdDetails> nativeAdDetails) {
        nativeAdsStartApp.addAll(nativeAdDetails);
        isAdLoaded = true;
    }

    public void setNativeAds(boolean isLoaded) {
        isAdLoaded = isLoaded;
    }

    private void populateStartAppNativeAdView(NativeAdDetails nativeAdDetails, RelativeLayout nativeAdView) {
        ImageView icon = nativeAdView.findViewById(R.id.icon);
        TextView title = nativeAdView.findViewById(R.id.title);
        TextView description = nativeAdView.findViewById(R.id.description);
        Button button = nativeAdView.findViewById(R.id.button);

        icon.setImageBitmap(nativeAdDetails.getImageBitmap());
        title.setText(nativeAdDetails.getTitle());
        description.setText(nativeAdDetails.getDescription());
        button.setText(nativeAdDetails.isApp() ? "Install" : "Open");
    }

    private void populateUnifiedNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        MediaView mediaView = adView.findViewById(R.id.ad_media);
        adView.setMediaView(mediaView);

        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) Objects.requireNonNull(adView.getHeadlineView())).setText(nativeAd.getHeadline());

        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            Objects.requireNonNull(adView.getIconView()).setVisibility(View.GONE);
        } else {
            ((ImageView) Objects.requireNonNull(adView.getIconView())).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            Objects.requireNonNull(adView.getStarRatingView()).setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) Objects.requireNonNull(adView.getStarRatingView()))
                    .setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            Objects.requireNonNull(adView.getAdvertiserView()).setVisibility(View.INVISIBLE);
        } else {
            ((TextView) Objects.requireNonNull(adView.getAdvertiserView())).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
        void onRewardAds(int position);
    }
}